<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ApplicationRequestModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		$this->load->database();
    }
    
    function create_request($name, $requestor, $url, $desc, $just, $poc_name, $poc_email, $poc_phone)
    {
    	$this->db->query('insert into application_request (name, requestor, requested_date, url, description, justification, poc_name, poc_email, poc_phone) values ('.$this->db->escape($name).','.$this->db->escape($requestor).','.$this->db->escape(date('U')).','.$this->db->escape($url).','.$this->db->escape($desc).','.$this->db->escape($just).','.$this->db->escape($poc_name).','.$this->db->escape($poc_email).','.$this->db->escape($poc_phone).')');
    }
    
    function update_request($id, $name, $url, $desc, $just, $poc_name, $poc_email, $poc_phone)
    {
    	$this->db->query('update application_request set requested_date = '.$this->db->escape(date('U')).',name = '.$this->db->escape($name).', url = '.$this->db->escape($url).', description = '.$this->db->escape($desc).', justification = '.$this->db->escape($just).', poc_name = '.$this->db->escape($poc_name).', poc_email = '.$this->db->escape($poc_email).', poc_phone = '.$this->db->escape($poc_phone).', denied = 0 where id = '.$this->db->escape($id));
    }
    
    function get_requests($type, $id = NULL)
    {
    	$query = 'select * from application_request where requested_date is not null and approved_date is';
    	
    	if ($type == 'approved'){
    		$query .= ' not null';
    		
    		if ($id !== NULL)
    			$query .= ' and requestor = '.$this->db->escape($id);
    		
    		$query .= ' order by approved_date desc';
    	}else if ($type == 'denied'){
    		$query .= ' null and denied = 1';
    		
    		if ($id !== NULL)
    			$query .= ' and requestor = '.$this->db->escape($id);
    		
    		$query .= ' order by requested_date desc';
    	}else{
    		$query .= ' null and (denied is null or denied = 0)';
    		
    		if ($id !== NULL)
    			$query .= ' and requestor = '.$this->db->escape($id);
    		
    		$query .= ' order by requested_date desc';
    	}
    	
    	return $this->db->query($query);
    }
    
    public function get_requests_by_page_number($type, $id = NULL, $start, $size){
    	
    	if ($type == 'approved'){
    		$approveQuery = ' not null';
    	
    		if ($id !== NULL)
    			$approveQuery .= ' and requestor = '.$this->db->escape($id);
    	
    		$orderQuery = ' order by approved_date desc, name';
    	}else if ($type == 'denied'){
    		$approveQuery = ' null and denied = 1';
    	
    		if ($id !== NULL)
    			$approveQuery .= ' and requestor = '.$this->db->escape($id);
    	
    		$orderQuery = ' order by requested_date desc, name';
    	}else{
    		$approveQuery = ' null and (denied is null or denied = 0)';
    	
    		if ($id !== NULL)
    			$approveQuery .= ' and requestor = '.$this->db->escape($id);
    	
    		$orderQuery = ' order by requested_date desc, name';
    	}
    	
    	$query = 'select * from (select *, ROW_NUMBER() over ( ' . $orderQuery . ') as row FROM application_request WHERE ' .
    	'requested_date is not null and approved_date is ' . $approveQuery;
    	
    	$query .= ') a where row >= ' . $this->db->escape($start) . ' and row < ' . $this->db->escape($size+$start);
    	
    	return $this->db->query($query);
    }
    
    public function get_requests_size($type, $id = NULL)
    {
    	$query = 'select COUNT(*) as count from application_request where requested_date is not null and approved_date is';
    	 
    	if ($type == 'approved'){
    		$query .= ' not null';
    
    		if ($id !== NULL)
    			$query .= ' and requestor = '.$this->db->escape($id);
    
    	}else if ($type == 'denied'){
    		$query .= ' null and denied = 1';
    
    		if ($id !== NULL)
    			$query .= ' and requestor = '.$this->db->escape($id);
    
    	}else{
    		$query .= ' null and (denied is null or denied = 0)';
    
    		if ($id !== NULL)
    			$query .= ' and requestor = '.$this->db->escape($id);
    	}
    	 
    	return $this->db->query($query);
    }
    
    function approve_request($request_id)
    {
    	return $this->db->query('update application_request set approved_date = '.$this->db->escape(date('U')).' where id = '.$this->db->escape($request_id));
    }
    
    function deny_request($request_id, $reason)
    {
    	return $this->db->query('update application_request set denied = 1, denial_reason = '.$this->db->escape($reason).' where id = '.$this->db->escape($request_id));
    }
    
    function get_request($request_id)
    {
    	return $this->db->query('select * from application_request where id = '.$this->db->escape($request_id));
    }
	function get_ids($name){
		return  $this->db->query('SELECT id FROM application_request WHERE name like '.$this->db->escape($name));
	}
}